@echo off
REM ---------------------------------------------------------------------------
REM
REM  Copyright (C) Intel Corporation, 2003 - 2006.
REM
REM  File:      certgen.bat
REM
REM  Contents:  batch file which creates a certificate for the provisioned 
REM				device. 
REM
REM ----------------------------------------------------------------------------

REM #######################################################################
REM ###                                                                 ###
REM ### This script is called by the Configuration Server program       ###
REM ### in order to generate a certificate for the device being         ###
REM ### provisioned. The batch is called by genCertChain.bat which      ###
REM ### uses the certificate created here to make a trust chain         ###
REM ### starting at the root CA down to the device's certificate (the   ###
REM ### one created here).                                              ###
REM ### you may customize this script and modify the defaults           ###
REM ### at your own risk.                                               ###
REM ###                                                                 ###
REM #######################################################################

setlocal

set PATH=%PATH%;../openSSL
set DAYS=-days 365
set CASUB=.\subCA

IF "%PROVISIONING_KEY_FILE%"==""  SET PROVISIONING_KEY_FILE=newkey.pem
IF "%PROVISIONING_CERT_FILE%"=="" SET PROVISIONING_CERT_FILE=newcert.pem
IF "%PROVISIONING_UUID%"=="" goto nouuid
IF "%PROVISIONING_HOSTNAME%"=="" goto nohostname
IF "%PROVISIONING_DOMAIN%"=="" goto nodomain
IF "%PROVISIONING_RSA_KEY_BITS%"=="" goto nokeysize

REM ### Create request ###
openssl req -config ..\secConfig\Uss.cfg -newkey rsa:%PROVISIONING_RSA_KEY_BITS% -keyout %PROVISIONING_KEY_FILE% -out newreq.pem %DAYS%

REM ### Sign request ###
del /q %CASUB%\serial.old %CASUB%\index.txt.old %CASUB%\index.txt.attr.old

set SSLEAY_CONFIG=-config ../openSSL/openssl_sub.cfg

openssl ca %SSLEAY_CONFIG% -policy policy_anything -out %PROVISIONING_CERT_FILE% -infiles newreq.pem < yy.txt

openssl x509 -in newcert.pem -inform PEM -out newcert.der -outform DER

REM -- Convet to an MS CERT format (optional) --
REM openssl x509 -in newcert.pem -inform PEM -out newcert.x509.cer -outform PEM

endlocal
goto end

:nouuid
echo Error, could not run batch:
echo %0 cannot continue because the PROVISIONING_UUID variable is not set
echo Note: The Configuration software sets this variable before calling this batch
echo .
pause 
goto end

:nohostname
echo Error, could not run batch:
echo %0 cannot continue because the PROVISIONING_HOSTNAME variable is not set
echo Note: The Configuration software sets this variable before calling this batch
echo .
pause 
goto end

:nodomain
echo Error, could not run batch:
echo %0 cannot continue because the PROVISIONING_DOMAIN variable is not set
echo Note: The Configuration software sets this variable before calling this batch
echo .
pause 
goto end

:nokeysize
echo Error, could not run batch:
echo %0 cannot continue because the PROVISIONING_RSA_KEY_BITS variable is not set
echo Note: The Configuration software sets this variable before calling this batch
echo .
pause 

:end
